#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#include "WHEEL_READ/wheel.h"
#include "ENGINE_READ/engine.h"

#define SEC_IN_USECS 1000000
#define MAX_SPEED 1070
#define MAX_REV 1300


void init (void) 
{
  init_wheel_speedometer();
  init_engine_speedometer();
}

int 
main () 
{
  unsigned int wheel_speed, engine_speed; /*should be unsigned int and on separate lines*/


  init ();


  while (1) 
    {
      wheel_speed = get_wheel_speed();
      engine_speed = get_engine_speed();
      
      
      printf ("Wheel speed: %-12d\tEngine speed: %-12d\n",
	      wheel_speed, engine_speed);
      
      if (wheel_speed > MAX_SPEED && engine_speed > MAX_REV)
	{
	  printf ("You're pushing things a bit too far.\n");
	}
      
      usleep (SEC_IN_USECS);
    }
  
  return 0;
}
